/* ESERCIZIO: creare una classe CopiaFile che permetta di clonare un file. 
 * In altre parole, deve mettere a disposizione il metodo copiaFile che prenda in input 
 * una stringa nome file sorgente, una stringa nome file destinazione, ed effettui la copia di un file, 
 * cioè crei un altro file con lo stesso contenuto del primo.
 * L'utente deve essere in grado di specificare da tastiera il nome del file sorgente, il nome del file di destinazione,
 * e nel caso il file di destinazione esista goa' deve poter scegliere se sovrascrivere (cioè cancellare e ricreare) quel file.
 * Consigli: - per copiare un file, si puo' leggere ogni riga del file sorgente e scriverla sul file di destinazione.
 *           - si possono usare i metodi visti a lezione, es: esisteFile per controllare se i file esistono
 *           - utilizzare Scanner per leggere da tastiera i nomi dei file e la scelta dell'utente per indicare di sovrascrivere
 *           - quando si chiede di sovrascrivere il file, si può chiedere all'utente di scrivere il carattere 's' per confermare;
 *             qualunque altro carattere puo' essre considerato come un 'no'. Per fare questo, per esempio si puo leggere da tastiera 
 *             la riga scritta dall'utente ottenendo un stringa, e controllare il primo carattere utilizzando il metodo charAt(0) 
 *             sulla stringa.
 */
import java.io.*;

public class CopiaFile
{   
    //metodo che restituisce true se un certo file esiste, false atrimenti
    public boolean esisteFile(String perc)
    {
        File f = new File(perc);
        return f.exists();
    }
    
    //funzione che copia un file sorgente in un file di destinazione
    //il file sorgente deve esistere, quello di destinazione deve non esistere
    public boolean copiaFile(String sorgente, String destinazione)
    {
        if(!esisteFile(sorgente) || esisteFile(destinazione))
            return false;
        
        try {
            //si crea il file di destinazione
            creaFile(destinazione);
            //si aprono i file di input (in lettura) e output(in scrittura)
            BufferedReader fileIn = new BufferedReader(new FileReader(sorgente));
            BufferedWriter fileOut = new BufferedWriter(new FileWriter(destinazione, true));
            
            String s;
            //si legge ogni riga dal file sorgente e si scrive nel file di destinazione
            //il ciclo termina quando si legge una riga nulla, cioè si è arrivati alla fine del file
            while( (s = fileIn.readLine()) != null) { 
                fileOut.append(s);
                fileOut.newLine();  //usare il metodo newLine() per inserire un 'a capo'
            }
            //una volta completate le operazioni, si devono chiudere i file
            fileIn.close();
            fileOut.close();
            return true;
        } catch (IOException e) {
            System.out.println(" !!! Errore durante la copia");
            e.printStackTrace();
        }
        return false;
    }
    
    //metodo che crea un file e lo restituisce (se non esiste)
    public File creaFile(String nomeFile)
    {
        if(!esisteFile(nomeFile) ) {
            //si crea il file
            try {
                File file = new File(nomeFile);
                file.createNewFile();
                return file;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //nel caso non sia possibile creare il file 
        //(es: viene lanciata una exception), si restituisce null
        return null;
    }
    
    //metodo che rimuove un file, se esiste; restituisce l'esito della rimozione
    public boolean rimuoviFile(String nomeFile)
    {
        try {
            if(esisteFile(nomeFile)) {
                File file = new File(nomeFile);
                //cancella un file; se il file è una cartella, deve essere vuota per poter essere cancellata
                file.delete();
                return true;
            }
        } catch (SecurityException e) {
            e.printStackTrace();
        }
        return false;
    }
}
